/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.HSLColor;
import java.awt.Color;

public class ColorFunctions {
    public static Color applyFunctions(Color color, ColorFunction ... functions) {
        float[] hsl = HSLColor.fromRGB(color);
        float alpha = (float)color.getAlpha() / 255.0f;
        for (ColorFunction function : functions) {
            function.apply(hsl);
        }
        return HSLColor.toRGB(hsl, alpha);
    }

    public static float clamp(float value) {
        return value < 0.0f ? 0.0f : (value > 100.0f ? 100.0f : value);
    }

    public static class HSLIncreaseDecrease
    implements ColorFunction {
        public final int hslIndex;
        public final boolean increase;
        public final float amount;
        public final boolean relative;
        public final boolean autoInverse;

        public HSLIncreaseDecrease(int hslIndex, boolean increase, float amount, boolean relative, boolean autoInverse) {
            this.hslIndex = hslIndex;
            this.increase = increase;
            this.amount = amount;
            this.relative = relative;
            this.autoInverse = autoInverse;
        }

        @Override
        public void apply(float[] hsl) {
            float amount2 = this.increase ? this.amount : -this.amount;
            amount2 = this.autoInverse && this.shouldInverse(hsl) ? -amount2 : amount2;
            hsl[this.hslIndex] = ColorFunctions.clamp(this.relative ? hsl[this.hslIndex] * ((100.0f + amount2) / 100.0f) : hsl[this.hslIndex] + amount2);
        }

        protected boolean shouldInverse(float[] hsl) {
            return this.increase ? hsl[this.hslIndex] >= 50.0f : hsl[this.hslIndex] < 50.0f;
        }
    }

    public static interface ColorFunction {
        public void apply(float[] var1);
    }
}

