/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

public class AquaComboBoxRenderer
implements ListCellRenderer<Object>,
UIResource {
    protected static int menuLabelLeftInset = OSXSystemProperties.OSVersion >= 1016 ? 25 : 21;
    protected static int editableMenuLabelLeftInset = OSXSystemProperties.OSVersion >= 1015 ? 16 : 5;
    protected static int menuLabelRightInset = OSXSystemProperties.OSVersion >= 1015 ? 19 : 5;
    protected static int menuLabelTopInset = 2;
    protected static int menuLabelBottomInset = 3;
    protected static int miniMenuLabelTopInset = 1;
    protected static int miniMenuLabelBottomInset = 0;
    protected static int checkMarkLeftInset = OSXSystemProperties.OSVersion >= 1016 ? 10 : (OSXSystemProperties.OSVersion >= 1015 ? 7 : 5);
    protected static int checkMarkTopInset = 3;
    protected static int pullDownMenuLabelLeftInset = menuLabelRightInset;
    @NotNull
    protected final JComboBox<?> comboBox;
    protected final boolean isList;
    @NotNull
    protected AquaUIPainter.Size size;
    @Nullable
    protected ListCellRenderer<Object> customRenderer;
    @Nullable
    protected Wrapper wrapper;
    @Nullable
    protected MyDefaultComponent defaultComponent;
    protected boolean shouldDisplayCheckMark;

    public AquaComboBoxRenderer(@NotNull JComboBox<?> jComboBox, boolean bl, @NotNull AquaUIPainter.Size size) {
        this.comboBox = jComboBox;
        this.isList = bl;
        this.size = size;
    }

    public void setSize(@NotNull AquaUIPainter.Size size) {
        this.size = size;
    }

    public void setCustomRenderer(@Nullable ListCellRenderer<Object> listCellRenderer) {
        this.customRenderer = listCellRenderer;
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
        JComponent jComponent;
        Object object2;
        boolean bl3 = this.shouldDisplayCheckMark = !this.comboBox.isEditable() && this.shouldDisplayCheckMark(n);
        if (this.customRenderer != null) {
            object2 = this.customRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (this.wrapper == null) {
                this.wrapper = new Wrapper();
            }
            this.wrapper.setComponent((Component)object2);
            jComponent = this.wrapper;
        } else {
            if (this.defaultComponent == null) {
                this.defaultComponent = new MyDefaultComponent();
            }
            if (object instanceof Icon) {
                this.defaultComponent.setIcon((Icon)object);
                this.defaultComponent.setText("");
            } else {
                object2 = object != null ? object.toString() : "";
                this.defaultComponent.setText((String)object2);
                this.defaultComponent.setIcon(null);
            }
            jComponent = this.defaultComponent;
        }
        jComponent.setFont(jList.getFont());
        jComponent.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isList) {
            n2 = this.size == AquaUIPainter.Size.MINI ? miniMenuLabelTopInset : menuLabelTopInset;
            int n6 = n4 = this.size == AquaUIPainter.Size.MINI ? miniMenuLabelBottomInset : menuLabelBottomInset;
            n3 = this.comboBox.isEditable() ? editableMenuLabelLeftInset : (this.isPullDown() ? pullDownMenuLabelLeftInset : menuLabelLeftInset);
            n5 = menuLabelRightInset;
        }
        jComponent.setBorder(new EmptyBorder(n2, n3, n4, n5));
        return jComponent;
    }

    protected void paintMark(@NotNull Graphics graphics, @NotNull JComponent jComponent) {
        if (this.shouldDisplayCheckMark) {
            Icon icon = AquaImageFactory.getPopupMenuItemCheckIcon(this.size);
            Color color = jComponent.getForeground();
            Image image = AquaImageFactory.getProcessedImage(icon, (Object)color);
            int n = jComponent.getHeight();
            int n2 = checkMarkLeftInset;
            int n3 = Math.max(checkMarkTopInset, (n - icon.getIconHeight() - 1) / 2);
            graphics.drawImage(image, n2, n3, null);
        }
    }

    private boolean shouldDisplayCheckMark(int n) {
        if (n >= 0 && this.isList) {
            Object obj = this.comboBox.getItemAt(n);
            return obj != null && obj.equals(this.comboBox.getSelectedItem()) && !this.isPullDown();
        }
        return false;
    }

    protected boolean isPullDown() {
        AquaComboBoxUI aquaComboBoxUI;
        if (!this.comboBox.isEditable() && (aquaComboBoxUI = AquaUtils.getUI(this.comboBox, AquaComboBoxUI.class)) != null) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)aquaComboBoxUI.getLayoutConfiguration();
            return popupButtonLayoutConfiguration != null && !popupButtonLayoutConfiguration.isPopUp();
        }
        return false;
    }

    private class Wrapper
    extends JComponent {
        public Wrapper() {
            this.setLayout(new BorderLayout());
        }

        public void setComponent(@NotNull Component component) {
            this.removeAll();
            this.add(component);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            AquaComboBoxRenderer.this.paintMark(graphics, this);
        }
    }

    private class MyDefaultComponent
    extends JLabel {
        private MyDefaultComponent() {
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension;
            String string = this.getText();
            if (string == null || string.isEmpty()) {
                this.setText(" ");
                dimension = super.getPreferredSize();
                this.setText("");
            } else {
                dimension = super.getPreferredSize();
            }
            return dimension;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            AquaComboBoxRenderer.this.paintMark(graphics, this);
        }
    }
}

