/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaTextComponentSupport;
import org.violetlib.aqua.AquaTextComponentUIDelegate;
import org.violetlib.aqua.AquaTextPaneUIDelegate;

public class AquaEditorPaneUIDelegate
implements AquaTextComponentUIDelegate {
    private static final String FONT_ATTRIBUTE_KEY = "FONT_ATTRIBUTE_KEY";

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "EditorPane";
    }

    @Override
    public void install(@NotNull JTextComponent jTextComponent) {
        this.updateDisplayProperties(jTextComponent, jTextComponent.getFont(), jTextComponent.getForeground());
    }

    @Override
    public void uninstall(@NotNull JTextComponent jTextComponent) {
        this.cleanDisplayProperties(jTextComponent);
    }

    @Override
    public boolean propertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if ("editorKit".equals(string)) {
            ActionMap actionMap = SwingUtilities.getUIActionMap(jTextComponent);
            if (actionMap != null) {
                Action[] actionArray;
                Action[] actionArray2;
                Object object = propertyChangeEvent.getOldValue();
                if (object instanceof EditorKit && (actionArray2 = ((EditorKit)object).getActions()) != null) {
                    this.removeActions(actionMap, actionArray2);
                }
                if ((actionArray2 = propertyChangeEvent.getNewValue()) instanceof EditorKit && (actionArray = ((EditorKit)actionArray2).getActions()) != null) {
                    this.addActions(actionMap, actionArray);
                }
            }
            AquaTextComponentSupport.updateFocusTraversalKeys(jTextComponent, this.getEditorKit(jTextComponent));
        } else if ("editable".equals(string)) {
            AquaTextComponentSupport.updateFocusTraversalKeys(jTextComponent, this.getEditorKit(jTextComponent));
        } else if ("foreground".equals(string) || "font".equals(string) || "document".equals(string) || "JEditorPane.w3cLengthUnits".equals(string) || "JEditorPane.honorDisplayProperties".equals(string)) {
            this.updateDisplayProperties(jTextComponent, jTextComponent.getFont(), jTextComponent.getForeground());
            if ("foreground".equals(string)) {
                Object object = jTextComponent.getClientProperty("JEditorPane.honorDisplayProperties");
                boolean bl = false;
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                }
                if (bl) {
                    return true;
                }
            }
            if ("JEditorPane.w3cLengthUnits".equals(string) || "JEditorPane.honorDisplayProperties".equals(string)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public EditorKit getEditorKit(@NotNull JTextComponent jTextComponent) {
        JEditorPane jEditorPane = (JEditorPane)jTextComponent;
        return jEditorPane.getEditorKit();
    }

    @Override
    @Nullable
    public View create(@NotNull JTextComponent jTextComponent, Element element) {
        return null;
    }

    @Override
    public int getBaseline(@NotNull JTextComponent jTextComponent, int n, int n2) {
        return -1;
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JTextComponent jTextComponent) {
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    @Nullable
    public ActionMap getActionMap(@NotNull JTextComponent jTextComponent) {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new FocusAction(jTextComponent));
        EditorKit editorKit = this.getEditorKit(jTextComponent);
        Action[] actionArray = editorKit.getActions();
        if (actionArray != null) {
            this.addActions(actionMapUIResource, actionArray);
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    private void removeActions(ActionMap actionMap, Action[] actionArray) {
        for (Action action : actionArray) {
            actionMap.remove(action.getValue("Name"));
        }
    }

    private void addActions(ActionMap actionMap, Action[] actionArray) {
        for (Action action : actionArray) {
            actionMap.put(action.getValue("Name"), action);
        }
    }

    private void updateDisplayProperties(@NotNull JTextComponent jTextComponent, Font font, Color color) {
        Document document;
        Object object = jTextComponent.getClientProperty("JEditorPane.honorDisplayProperties");
        boolean bl = false;
        Object object2 = jTextComponent.getClientProperty("JEditorPane.w3cLengthUnits");
        boolean bl2 = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (object2 instanceof Boolean) {
            bl2 = (Boolean)object2;
        }
        if (this instanceof AquaTextPaneUIDelegate || bl) {
            document = jTextComponent.getDocument();
            if (document instanceof StyledDocument) {
                if (document instanceof HTMLDocument && bl) {
                    this.updateCSS(jTextComponent, font, color);
                } else {
                    this.updateStyle(jTextComponent, font, color);
                }
            }
        } else {
            this.cleanDisplayProperties(jTextComponent);
        }
        if (bl2) {
            document = jTextComponent.getDocument();
            if (document instanceof HTMLDocument) {
                StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
                styleSheet.addRule("W3C_LENGTH_UNITS_ENABLE");
            }
        } else {
            document = jTextComponent.getDocument();
            if (document instanceof HTMLDocument) {
                StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
                styleSheet.addRule("W3C_LENGTH_UNITS_DISABLE");
            }
        }
    }

    private void cleanDisplayProperties(@NotNull JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        if (document instanceof HTMLDocument) {
            Object object;
            StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
            StyleSheet[] styleSheetArray = styleSheet.getStyleSheets();
            if (styleSheetArray != null) {
                object = styleSheetArray;
                int n = ((StyleSheet[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object2 = object[i];
                    if (!(object2 instanceof StyleSheetUIResource)) continue;
                    styleSheet.removeStyleSheet((StyleSheet)object2);
                    styleSheet.addRule("BASE_SIZE_DISABLE");
                    break;
                }
            }
            if ((object = ((StyledDocument)document).getStyle("default")).getAttribute(FONT_ATTRIBUTE_KEY) != null) {
                object.removeAttribute(FONT_ATTRIBUTE_KEY);
            }
        }
    }

    private void updateCSS(@NotNull JTextComponent jTextComponent, Font font, Color color) {
        Document document = jTextComponent.getDocument();
        if (document instanceof HTMLDocument) {
            StyleSheetUIResource styleSheetUIResource = new StyleSheetUIResource();
            StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
            StyleSheet[] styleSheetArray = styleSheet.getStyleSheets();
            if (styleSheetArray != null) {
                for (StyleSheet styleSheet2 : styleSheetArray) {
                    if (!(styleSheet2 instanceof StyleSheetUIResource)) continue;
                    styleSheet.removeStyleSheet(styleSheet2);
                }
            }
            String string = AquaTextComponentSupport.displayPropertiesToCSS(font, color);
            styleSheetUIResource.addRule(string);
            styleSheet.addStyleSheet(styleSheetUIResource);
            styleSheet.addRule("BASE_SIZE " + jTextComponent.getFont().getSize());
            Style style = ((StyledDocument)document).getStyle("default");
            if (!font.equals(style.getAttribute(FONT_ATTRIBUTE_KEY))) {
                style.addAttribute(FONT_ATTRIBUTE_KEY, font);
            }
        }
    }

    private void updateStyle(@NotNull JTextComponent jTextComponent, Font font, Color color) {
        this.updateFont(jTextComponent, font);
        this.updateForeground(jTextComponent, color);
    }

    private void updateForeground(@NotNull JTextComponent jTextComponent, Color color) {
        StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
        Style style = styledDocument.getStyle("default");
        if (style == null) {
            return;
        }
        if (color == null) {
            if (style.getAttribute(StyleConstants.Foreground) != null) {
                style.removeAttribute(StyleConstants.Foreground);
            }
        } else if (!color.equals(StyleConstants.getForeground(style))) {
            StyleConstants.setForeground(style, color);
        }
    }

    private void updateFont(@NotNull JTextComponent jTextComponent, Font font) {
        StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
        Style style = styledDocument.getStyle("default");
        if (style == null) {
            return;
        }
        String string = (String)style.getAttribute(StyleConstants.FontFamily);
        Integer n = (Integer)style.getAttribute(StyleConstants.FontSize);
        Boolean bl = (Boolean)style.getAttribute(StyleConstants.Bold);
        Boolean bl2 = (Boolean)style.getAttribute(StyleConstants.Italic);
        Font font2 = (Font)style.getAttribute(FONT_ATTRIBUTE_KEY);
        if (font == null) {
            if (string != null) {
                style.removeAttribute(StyleConstants.FontFamily);
            }
            if (n != null) {
                style.removeAttribute(StyleConstants.FontSize);
            }
            if (bl != null) {
                style.removeAttribute(StyleConstants.Bold);
            }
            if (bl2 != null) {
                style.removeAttribute(StyleConstants.Italic);
            }
            if (font2 != null) {
                style.removeAttribute(FONT_ATTRIBUTE_KEY);
            }
        } else {
            if (!font.getName().equals(string)) {
                StyleConstants.setFontFamily(style, font.getName());
            }
            if (n == null || n.intValue() != font.getSize()) {
                StyleConstants.setFontSize(style, font.getSize());
            }
            if (bl == null || bl.booleanValue() != font.isBold()) {
                StyleConstants.setBold(style, font.isBold());
            }
            if (bl2 == null || bl2.booleanValue() != font.isItalic()) {
                StyleConstants.setItalic(style, font.isItalic());
            }
            if (!font.equals(font2)) {
                style.addAttribute(FONT_ATTRIBUTE_KEY, font);
            }
        }
    }

    private static class FocusAction
    extends AbstractAction {
        @NotNull
        private final JTextComponent editor;

        public FocusAction(@NotNull JTextComponent jTextComponent) {
            this.editor = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.editor.requestFocus();
        }

        @Override
        public boolean isEnabled() {
            return this.editor.isEditable();
        }
    }

    private static class StyleSheetUIResource
    extends StyleSheet
    implements UIResource {
        private StyleSheetUIResource() {
        }
    }
}

