/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaBackgroundBorder;
import org.violetlib.aqua.AquaCellBorder;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaFieldView;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaMarginView;
import org.violetlib.aqua.AquaTextComponentBorder;
import org.violetlib.aqua.AquaTextComponentUIBase;
import org.violetlib.aqua.AquaTextFieldSearch;
import org.violetlib.aqua.AquaTextFieldUIDelegate;
import org.violetlib.aqua.AquaTreeEditorBorder;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.aqua.ToolbarSensitiveUI;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;

public class AquaTextFieldUI
extends AquaTextComponentUIBase
implements ToolbarSensitiveUI {
    public static final String TEXT_FIELD_STYLE_KEY = "JTextField.style";
    public static final String TEXT_FIELD_VARIANT_KEY = "JTextField.variant";
    public static final String QUAQUA_TEXT_FIELD_STYLE_KEY = "Quaqua.TextField.style";
    protected HierarchyListener hierarchyListener;
    protected View topView;
    protected boolean isToolbar;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent jComponent) {
        return new AquaTextFieldUI();
    }

    public AquaTextFieldUI() {
        super(new AquaTextFieldUIDelegate());
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.isToolbar = AquaUtils.isOnToolbar(jComponent);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.installBorder();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.hierarchyListener = new AquaHierarchyListener();
        this.editor.addHierarchyListener(this.hierarchyListener);
        AquaUtils.installToolbarSensitivity(this.editor);
    }

    @Override
    protected void uninstallListeners() {
        AquaUtils.uninstallToolbarSensitivity(this.editor);
        this.editor.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        super.uninstallListeners();
    }

    protected void installBorder() {
        Border border = this.editor.getBorder();
        if ((border == null || border instanceof UIResource) && !(border instanceof AquaTreeEditorBorder)) {
            this.editor.setBorder(new AquaTextComponentBorder(this.editor));
        }
    }

    @Override
    @NotNull
    protected AquaFocusHandler createFocusHandler() {
        return new AquaTextFieldFocusHandler();
    }

    @Override
    protected void propertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
        Object object;
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (this.isStyleProperty(string) || AquaCellEditorPolicy.isCellEditorProperty(string)) {
            this.updateStyle();
        } else if ("Aqua.componentColors".equals(string) && (object = propertyChangeEvent.getNewValue()) instanceof BasicContextualColors) {
            this.colors = (BasicContextualColors)object;
            this.configureAppearanceContext(null);
        }
    }

    @Override
    public void toolbarStatusChanged(@NotNull JComponent jComponent) {
        boolean bl = AquaUtils.isOnToolbar(jComponent);
        if (bl != this.isToolbar) {
            this.isToolbar = bl;
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    public void updateStyle() {
        if (this.wantsToBeASearchField()) {
            AquaTextFieldSearch.installSearchField(this.editor);
        } else {
            AquaTextFieldSearch.uninstallSearchField(this.editor);
        }
        if (this.topView instanceof AquaMarginView) {
            AquaMarginView aquaMarginView = (AquaMarginView)this.topView;
            int n = this.getTextMargin();
            aquaMarginView.setMargin(n);
        }
        this.editor.revalidate();
        this.editor.repaint();
    }

    protected boolean wantsToBeASearchField() {
        String string = this.getStyleProperty();
        return "search".equals(string);
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, TEXT_FIELD_STYLE_KEY, TEXT_FIELD_VARIANT_KEY, QUAQUA_TEXT_FIELD_STYLE_KEY);
    }

    @Nullable
    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.editor, TEXT_FIELD_STYLE_KEY, TEXT_FIELD_VARIANT_KEY, QUAQUA_TEXT_FIELD_STYLE_KEY);
    }

    @Override
    @Nullable
    public final View create(@NotNull Element element) {
        this.topView = this.createView(element);
        return this.topView;
    }

    @Nullable
    private View createView(@NotNull Element element) {
        View view = this.createBasicView(element);
        int n = this.getTextMargin();
        if (n > 0 && view instanceof AquaFieldView) {
            return new AquaMarginView(view, n);
        }
        return view;
    }

    @Nullable
    protected View createBasicView(@NotNull Element element) {
        Class<?> clazz;
        View view = this.delegate.create(this.editor, element);
        if (view != null && (clazz = view.getClass()) == FieldView.class) {
            return new AquaFieldView(element);
        }
        return view;
    }

    public int getTextMargin() {
        Border border = this.editor.getBorder();
        if (border instanceof AquaTextComponentBorder) {
            AquaTextComponentBorder aquaTextComponentBorder = (AquaTextComponentBorder)border;
            return aquaTextComponentBorder.getTextMargin();
        }
        return 0;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getLayoutSize(LayoutOption.MAXIMUM);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getLayoutSize(LayoutOption.PREFERRED);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getLayoutSize(LayoutOption.MINIMUM);
    }

    protected Dimension getLayoutSize(LayoutOption layoutOption) {
        Dimension dimension = this.getLayoutSizeFromText(layoutOption);
        Border border = this.editor.getBorder();
        if (border instanceof AquaTextComponentBorder) {
            AquaTextComponentBorder aquaTextComponentBorder = (AquaTextComponentBorder)border;
            LayoutInfo layoutInfo = aquaTextComponentBorder.getLayoutInfo();
            int n = (int)Math.max((float)dimension.width, layoutInfo.getMinimumVisualWidth());
            int n2 = (int)Math.max((float)dimension.height, layoutInfo.getMinimumVisualHeight());
            return new Dimension(n, n2);
        }
        return dimension;
    }

    protected Dimension getLayoutSizeFromText(LayoutOption layoutOption) {
        Object object;
        Insetter insetter;
        Dimension dimension = this.getTextSize(layoutOption);
        int n = dimension.width;
        int n2 = dimension.height;
        Border border = this.editor.getBorder();
        if (border instanceof AquaTextComponentBorder && (insetter = ((AquaTextComponentBorder)(object = (AquaTextComponentBorder)border)).getTextInsets()) != null) {
            int n3 = layoutOption != LayoutOption.MINIMUM ? ((AquaTextComponentBorder)object).getExtraHeight() : 0;
            Dimension dimension2 = insetter.expand(new Dimension(n, n2 + n3));
            return dimension2;
        }
        object = this.editor.getInsets();
        return new Dimension(n + ((Insets)object).left + ((Insets)object).right, n2 + ((Insets)object).top + ((Insets)object).bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getTextSize(LayoutOption layoutOption) {
        Dimension dimension = new Dimension();
        if (this.topView != null) {
            Document document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            if (layoutOption == LayoutOption.PREFERRED) {
                Dimension dimension2 = this.editor.getSize();
                if (dimension2.width == 0 && dimension2.height == 0) {
                    this.topView.setSize(2.1474836E9f, 2.1474836E9f);
                } else {
                    Insets insets = this.editor.getInsets();
                    if (dimension2.width > insets.left + insets.right && dimension2.height > insets.top + insets.bottom) {
                        this.topView.setSize(dimension2.width - insets.left - insets.right, dimension2.height - insets.top - insets.bottom);
                    }
                }
            }
            try {
                float f = 0.0f;
                float f2 = 0.0f;
                switch (layoutOption) {
                    case MINIMUM: {
                        f = this.topView.getMinimumSpan(0);
                        f2 = this.topView.getMinimumSpan(1);
                        break;
                    }
                    case PREFERRED: {
                        f = this.topView.getPreferredSpan(0);
                        f2 = this.topView.getPreferredSpan(1);
                        break;
                    }
                    case MAXIMUM: {
                        f = this.topView.getMaximumSpan(0);
                        f2 = this.topView.getMaximumSpan(1);
                    }
                }
                dimension.width = (int)Math.min(100000.0f, f + 3.0f);
                dimension.height = (int)Math.min(100000.0f, f2);
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
        return dimension;
    }

    @Override
    protected void paintBackgroundSafely(@NotNull Graphics graphics, @Nullable Color color) {
        int n = this.editor.getWidth();
        int n2 = this.editor.getHeight();
        Border border = this.editor.getBorder();
        if (!(border instanceof AquaBackgroundBorder) && !(border instanceof AquaCellBorder)) {
            boolean bl = this.editor.isOpaque();
            if (!bl && JavaSupport.hasOpaqueBeenExplicitlySet(this.editor)) {
                return;
            }
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n2);
            }
            return;
        }
        if (border instanceof AquaBackgroundBorder) {
            AquaBackgroundBorder aquaBackgroundBorder = (AquaBackgroundBorder)border;
            aquaBackgroundBorder.paintBackground(this.editor, graphics, color);
        }
    }

    protected class AquaHierarchyListener
    implements HierarchyListener {
        protected AquaHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 1L) != 0L) {
                AquaTextFieldUI.this.updateStyle();
            }
        }
    }

    protected class AquaTextFieldFocusHandler
    extends AquaFocusHandler {
        protected AquaTextFieldFocusHandler() {
        }

        @Override
        public void focusLost(@NotNull FocusEvent focusEvent) {
            Caret caret;
            super.focusLost(focusEvent);
            if (!focusEvent.isTemporary() && (caret = AquaTextFieldUI.this.editor.getCaret()) != null) {
                caret.setDot(0);
            }
        }
    }

    protected static enum LayoutOption {
        MINIMUM,
        PREFERRED,
        MAXIMUM;

    }
}

