/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaBackgroundBorder;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.AquaTextComponentBorder;
import org.violetlib.aqua.AquaTextComponentUIBase;
import org.violetlib.aqua.AquaTextComponentUIDelegate;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.JavaSupport;

public class AquaTextPaneUIBase
extends AquaTextComponentUIBase {
    @Nullable
    protected JScrollPane owningScrollPane;
    @Nullable
    protected Container watchedParent;
    protected boolean installingBorder;
    @Nullable
    protected HierarchyListener hierarchyListener;
    @Nullable
    protected PropertyChangeListener scrollPaneBorderListener;
    @Nullable
    protected ContainerListener watchedParentContainerListener;

    public AquaTextPaneUIBase(@NotNull AquaTextComponentUIDelegate aquaTextComponentUIDelegate) {
        super(aquaTextComponentUIDelegate);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        aquaKeyBindings.installAquaUpDownActions(this.editor);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateBorderOwner();
    }

    @Override
    protected void uninstallDefaults() {
        this.clearScrollPaneBorder();
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.hierarchyListener = new MyHierarchyListener();
        this.editor.addHierarchyListener(this.hierarchyListener);
    }

    @Override
    protected void uninstallListeners() {
        this.editor.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void propertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("border".equals(string) && !this.installingBorder) {
            this.updateBorderOwner();
        }
    }

    protected void updateBorderOwner() {
        Border border;
        JScrollPane jScrollPane;
        Container container;
        Border border2;
        if (this.editor != null && !JavaSupport.hasOpaqueBeenExplicitlySet(this.editor) && ((border2 = this.editor.getBorder()) == null || border2 instanceof UIResource) && (container = this.editor.getParent()) instanceof JViewport && container.getComponentCount() == 1 && (jScrollPane = AquaUtils.getScrollPaneAncestor(this.editor)) != null && ((border = jScrollPane.getBorder()) == null || border instanceof UIResource)) {
            this.updateScrollPaneBorder(jScrollPane, container);
            return;
        }
        this.clearWatchedParent();
        this.clearOwningScrollPane();
    }

    protected void clearScrollPaneBorder() {
        this.clearWatchedParent();
        this.clearOwningScrollPane();
        this.installBorder();
    }

    private void installBorder() {
        Border border;
        if (this.editor != null && ((border = this.editor.getBorder()) == null || border instanceof UIResource)) {
            this.installingBorder = true;
            if (JavaSupport.hasOpaqueBeenExplicitlySet(this.editor)) {
                this.editor.setBorder(null);
            } else if (!(border instanceof AquaBackgroundBorder)) {
                AquaTextComponentBorder aquaTextComponentBorder = new AquaTextComponentBorder(this.editor);
                this.editor.setBorder(aquaTextComponentBorder);
            }
            this.installingBorder = false;
        }
    }

    private void clearWatchedParent() {
        if (this.watchedParent != null) {
            this.watchedParent.removeContainerListener(this.watchedParentContainerListener);
            this.watchedParent = null;
        }
    }

    private void clearOwningScrollPane() {
        if (this.owningScrollPane != null) {
            this.owningScrollPane.removePropertyChangeListener(this.scrollPaneBorderListener);
            LookAndFeel.installBorder(this.owningScrollPane, "ScrollPane.border");
            JViewport jViewport = this.owningScrollPane.getViewport();
            jViewport.setOpaque(true);
            LookAndFeel.installProperty(this.owningScrollPane, "opaque", Boolean.TRUE);
            this.owningScrollPane = null;
        }
    }

    protected void updateScrollPaneBorder(@NotNull JScrollPane jScrollPane, @NotNull Container container) {
        if (jScrollPane != this.owningScrollPane) {
            this.clearOwningScrollPane();
            this.owningScrollPane = jScrollPane;
            if (this.scrollPaneBorderListener == null) {
                this.scrollPaneBorderListener = new ScrollPaneBorderListener();
            }
            this.owningScrollPane.addPropertyChangeListener(this.scrollPaneBorderListener);
        }
        if (container != this.watchedParent) {
            this.clearWatchedParent();
            this.watchedParent = container;
            if (this.watchedParentContainerListener == null) {
                this.watchedParentContainerListener = new WatchedParentContainerListener();
            }
            this.watchedParent.addContainerListener(this.watchedParentContainerListener);
        }
        AquaTextComponentBorder aquaTextComponentBorder = new AquaTextComponentBorder(this.editor);
        this.installingBorder = true;
        jScrollPane.setBorder(aquaTextComponentBorder);
        LookAndFeel.installProperty(jScrollPane, "opaque", Boolean.FALSE);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setOpaque(false);
        this.editor.setBorder(null);
        this.installingBorder = false;
    }

    private class MyHierarchyListener
    implements HierarchyListener {
        private MyHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(@NotNull HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 1L) != 0L && AquaTextPaneUIBase.this.editor != null && AquaTextPaneUIBase.this.editor.getParent() != null) {
                AquaTextPaneUIBase.this.updateBorderOwner();
            }
        }
    }

    private class ScrollPaneBorderListener
    implements PropertyChangeListener {
        private ScrollPaneBorderListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("border".equals(string) && !AquaTextPaneUIBase.this.installingBorder) {
                AquaTextPaneUIBase.this.updateBorderOwner();
            }
        }
    }

    private class WatchedParentContainerListener
    implements ContainerListener {
        private WatchedParentContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            AquaTextPaneUIBase.this.updateBorderOwner();
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            AquaTextPaneUIBase.this.updateBorderOwner();
        }
    }
}

