/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.ComponentTracker;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.VisibleBounds;
import org.violetlib.aqua.VisualEffectViewPeer;

public class VisualEffectView {
    private final JComponent component;
    private final int style;
    private final boolean supportSelections;
    private VisualEffectViewPeer peer;
    private Rectangle oldBounds;
    private Window window;
    private int windowHeight;
    private ComponentTracker tracker;

    public VisualEffectView(JComponent jComponent, int n, boolean bl) {
        this.component = jComponent;
        this.style = n;
        this.supportSelections = bl;
        this.tracker = new MyComponentTracker();
        this.tracker.attach(this.component);
    }

    public int getStyle() {
        return this.style;
    }

    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    public void dispose() {
        if (this.tracker != null) {
            this.tracker.attach(null);
            this.tracker = null;
        }
    }

    public void updateSelectionBackgrounds(@Nullable SelectionBoundsDescription selectionBoundsDescription) {
        if (this.peer != null && this.supportSelections) {
            this.peer.updateSelectionBackgrounds(selectionBoundsDescription);
        }
    }

    protected void windowChanged(@Nullable Window window) {
        Window window2 = this.window;
        this.window = window;
        if (this.peer != null) {
            assert (window2 != null);
            if (window2 != this.window || !window2.isDisplayable()) {
                this.peer.dispose();
                this.peer = null;
                this.oldBounds = null;
            }
        }
        if (this.peer == null && this.window != null && this.window.isDisplayable()) {
            this.peer = AquaVibrantSupport.createVisualEffectView(this.window, this.style, this.supportSelections);
            this.visibleBoundsChanged();
        }
    }

    protected void visibleBoundsChanged() {
        VisibleBounds visibleBounds = AquaUtils.getVisibleBoundsInWindow(this.component);
        if (visibleBounds != null) {
            Rectangle rectangle = visibleBounds.frame;
            this.setFrame(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.setFrame(0, 0, 0, 0);
        }
    }

    private void setFrame(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = this.window != null ? this.window.getHeight() : 0;
        if (this.oldBounds == null || n != this.oldBounds.x || n2 != this.oldBounds.y || n3 != this.oldBounds.width || n4 != this.oldBounds.height || this.windowHeight != n5) {
            this.oldBounds = new Rectangle(n, n2, n3, n4);
            this.windowHeight = n5;
            if (this.peer != null) {
                this.peer.setFrame(n, n2, n3, n4);
            }
        }
    }

    private class MyComponentTracker
    extends ComponentTracker {
        private MyComponentTracker() {
        }

        @Override
        protected void attached(@Nullable Window window) {
            if (window != null) {
                VisualEffectView.this.windowChanged(window);
                VisualEffectView.this.visibleBoundsChanged();
            }
        }

        @Override
        protected void detached(@Nullable Window window) {
            if (VisualEffectView.this.window != null) {
                VisualEffectView.this.windowChanged(null);
            }
        }

        @Override
        protected void windowChanged(@Nullable Window window, @Nullable Window window2) {
            VisualEffectView.this.windowChanged(window2);
        }

        @Override
        protected void visibleBoundsChanged(@Nullable Window window) {
            if (window != null) {
                VisualEffectView.this.visibleBoundsChanged();
            }
        }
    }
}

