/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.fc.AquaFileChooserBrowserListUI;
import org.violetlib.aqua.fc.AquaFileChooserListMouseBehavior;
import org.violetlib.aqua.fc.JBrowser;

public class AquaFileChooserBrowser
extends JBrowser {
    protected final JFileChooser fc;
    protected final ColumnScrollPaneMouseWheelListener columnScrollPaneMouseWheelListener;

    public AquaFileChooserBrowser(JFileChooser jFileChooser) {
        this.fc = jFileChooser;
        this.columnScrollPaneMouseWheelListener = new ColumnScrollPaneMouseWheelListener();
    }

    @Override
    protected ListUI getColumnListUI(ListUI listUI) {
        AquaFileChooserBrowserListUI aquaFileChooserBrowserListUI = new AquaFileChooserBrowserListUI(this.fc);
        aquaFileChooserBrowserListUI.setFileSelectionHandler(new AquaFileChooserListMouseBehavior.FileSelectionHandler(){

            @Override
            public void fileSelected(File file) {
                AquaFileChooserBrowser.this.fileSelectedInSavePanel(file);
            }
        });
        return aquaFileChooserBrowserListUI;
    }

    @Override
    protected JScrollPane createScrollPane(@Nullable JComponent jComponent) {
        JScrollPane jScrollPane = super.createScrollPane(jComponent);
        jScrollPane.addMouseWheelListener(this.columnScrollPaneMouseWheelListener);
        return jScrollPane;
    }

    protected void fileSelectedInSavePanel(File file) {
    }

    protected class ColumnScrollPaneMouseWheelListener
    implements MouseWheelListener {
        protected ColumnScrollPaneMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JScrollPane jScrollPane;
            if (mouseWheelEvent.isShiftDown() && (jScrollPane = this.getBrowserScrollPane(mouseWheelEvent.getComponent())) != null) {
                MouseWheelEvent mouseWheelEvent2 = (MouseWheelEvent)SwingUtilities.convertMouseEvent(mouseWheelEvent.getComponent(), mouseWheelEvent, jScrollPane);
                jScrollPane.dispatchEvent(mouseWheelEvent2);
            }
        }

        protected JScrollPane getBrowserScrollPane(Component component) {
            Container container;
            while ((container = component.getParent()) != null && !(container instanceof JFileChooser)) {
                if (container instanceof JScrollPane) {
                    return (JScrollPane)container;
                }
                component = container;
            }
            return null;
        }
    }
}

