/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.fc.AquaFileChooserUI;
import org.violetlib.aqua.fc.AquaFileIcon;
import org.violetlib.aqua.fc.AquaFileIcons;
import org.violetlib.aqua.fc.AquaFileView;
import org.violetlib.aqua.fc.ConcurrentDispatcher;
import org.violetlib.aqua.fc.OSXFile;

public class FileAttributes {
    @NotNull
    private static final ConcurrentDispatcher dispatcher = new ConcurrentDispatcher();
    @NotNull
    private final JFileChooser fc;

    public FileAttributes(@NotNull JFileChooser jFileChooser) {
        this.fc = jFileChooser;
    }

    public int getLabel(@NotNull File file) {
        return OSXFile.getLabel(file);
    }

    @NotNull
    public String getKind(@NotNull File file) {
        String string = OSXFile.getKindString(file);
        if (string != null) {
            return string;
        }
        if (file.isDirectory()) {
            String string2 = file.getPath();
            if (string2.endsWith(".app")) {
                return "application";
            }
            if (string2.endsWith(".wdgt")) {
                return "widget";
            }
            return "folder";
        }
        return "document";
    }

    @NotNull
    public AquaFileIcon getIcon(@NotNull File file) {
        if (this.canGetFileIconDirectly()) {
            return AquaFileIcons.getThumbnail(file);
        }
        AquaFileIcon aquaFileIcon = new AquaFileIcon(16, 16);
        FileIconUpdater fileIconUpdater = new FileIconUpdater(this.fc, file, aquaFileIcon);
        dispatcher.dispatch(fileIconUpdater);
        return aquaFileIcon;
    }

    protected boolean canGetFileIconDirectly() {
        if (this.fc.getClass() != JFileChooser.class) {
            return false;
        }
        FileView fileView = this.fc.getFileView();
        if (fileView instanceof AquaFileView) {
            return true;
        }
        if (fileView == null) {
            FileChooserUI fileChooserUI = this.fc.getUI();
            return fileChooserUI instanceof AquaFileChooserUI;
        }
        return false;
    }

    private static class FileIconUpdater
    implements Runnable {
        @NotNull
        private final JFileChooser fc;
        @NotNull
        private final File f;
        @NotNull
        private final AquaFileIcon icon;

        public FileIconUpdater(@NotNull JFileChooser jFileChooser, @NotNull File file, @NotNull AquaFileIcon aquaFileIcon) {
            this.fc = jFileChooser;
            this.f = file;
            this.icon = aquaFileIcon;
        }

        @Override
        public void run() {
            Icon icon = this.fc.getIcon(this.f);
            this.icon.installIcon(icon);
        }
    }
}

