/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Image;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.fc.FileIconService;
import org.violetlib.aqua.fc.OSXFile;

public class FileIconServiceImplBase {
    @Nullable
    private ImageIcon genericFileIcon;
    @Nullable
    private ImageIcon genericFolderIcon;

    protected void installGenericFileIcon(@NotNull File file, @NotNull RequestImpl requestImpl) {
        if (file.isFile()) {
            if (this.genericFileIcon == null) {
                this.genericFileIcon = OSXFile.getFileIcon();
            }
            requestImpl.installIcon(this.genericFileIcon, 0);
        } else if (file.isDirectory()) {
            if (this.genericFolderIcon == null) {
                this.genericFolderIcon = OSXFile.getDirectoryIcon();
            }
            requestImpl.installIcon(this.genericFolderIcon, 0);
        }
    }

    protected class RequestImpl
    implements FileIconService.Request {
        @NotNull
        private final File f;
        private final int highestAcceptedPriority;
        @Nullable
        private FileIconService.Handler handler;
        private int highestReceivedPriority = -1;

        public RequestImpl(@Nullable File file, FileIconService.Handler handler) {
            this.f = file;
            this.handler = handler;
            this.highestAcceptedPriority = Integer.MAX_VALUE;
        }

        public RequestImpl(@Nullable File file, FileIconService.Handler handler, int n) {
            this.f = file;
            this.handler = handler;
            this.highestAcceptedPriority = n;
        }

        public synchronized void installIcon(@NotNull ImageIcon imageIcon, int n) {
            if (n > this.highestReceivedPriority && n <= this.highestAcceptedPriority && this.handler != null) {
                this.debug(imageIcon, n);
                this.handler.provideIcon(imageIcon, n);
                this.highestReceivedPriority = n;
            }
        }

        public synchronized void installImage(@NotNull Image image, int n) {
            if (n > this.highestReceivedPriority && this.handler != null) {
                ImageIcon imageIcon = new ImageIcon(image);
                this.debug(imageIcon, n);
                this.handler.provideIcon(imageIcon, n);
                this.highestReceivedPriority = n;
            }
        }

        private void debug(@NotNull Icon icon, int n) {
        }

        @Override
        public synchronized void cancel() {
            this.handler = null;
        }
    }
}

