/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaListUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.EffectName;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.GenericCellRenderer;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class FileRenderer
extends JLabel
implements ListCellRenderer,
GenericCellRenderer {
    @NotNull
    private final ImageIcon arrowIcon;
    @Nullable
    private Color arrowColor;
    private Icon aliasBadgeIcon;
    private int textIconGap = UIManager.getInt("FileChooser.browserCellTextIconGap");
    private int textArrowIconGap = UIManager.getInt("FileChooser.browserCellTextArrowIconGap");
    private Icon icon;
    private String text;
    @Nullable
    private Color labelColor;
    private boolean isSelected;
    private boolean isFocused;
    private boolean isGrayed;
    private boolean isAlias;
    private boolean isListView;
    private double labelRadius = 4.8;
    private Border border;
    private static final Color LABEL_BORDER_SELECTED = Color.WHITE;
    private static final Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle arrowIconRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle labelRect = new Rectangle();
    private static Rectangle r = new Rectangle();

    public FileRenderer(@NotNull JFileChooser jFileChooser) {
        this.aliasBadgeIcon = UIManager.getIcon("FileView.aliasBadgeIcon");
        this.arrowIcon = AquaIcon.getBrowserExpandArrowTemplate();
        this.border = FileRenderer.createBorder();
        this.setOpaque(true);
    }

    @NotNull
    private static Border createBorder() {
        if (OSXSystemProperties.useInsetViewStyle()) {
            return new EmptyBorder(2, 18, 2, 18);
        }
        return new EmptyBorder(0, 4, 2, 0);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public Component getListCellRendererComponent(@NotNull JList jList, @Nullable Object object, int n, boolean bl, boolean bl2) {
        AquaListUI aquaListUI = AquaUtils.getUI(jList, AquaListUI.class);
        AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(jList);
        ContainerContextualColors containerContextualColors = aquaListUI != null ? aquaListUI.getColors() : AquaColors.CONTAINER_COLORS;
        return this.getCellRendererComponent(jList, aquaAppearance, containerContextualColors, object, bl, bl2, false);
    }

    @Override
    public Component getCellRendererComponent(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance, @NotNull ContainerContextualColors containerContextualColors, @Nullable Object object, boolean bl, boolean bl2) {
        return this.getCellRendererComponent(jComponent, aquaAppearance, containerContextualColors, object, bl, bl2, true);
    }

    protected Component getCellRendererComponent(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance, @NotNull ContainerContextualColors containerContextualColors, @Nullable Object object, boolean bl, boolean bl2, boolean bl3) {
        Object object2;
        this.isListView = bl3;
        if (!(object instanceof FileInfo)) {
            return this;
        }
        FileInfo fileInfo = (FileInfo)object;
        this.isGrayed = !fileInfo.isAcceptable() && !fileInfo.isTraversable();
        this.labelColor = null;
        int n = fileInfo.getFileLabel();
        Object object3 = OSXFile.getTagColorName(n);
        if (object3 != null) {
            object2 = this.isGrayed ? EffectName.EFFECT_DISABLED : EffectName.EFFECT_NONE;
            this.labelColor = aquaAppearance.getColorForEffect((String)object3, (EffectName)object2);
        }
        this.isSelected = bl;
        this.isFocused = jComponent.isEnabled() && AquaFocusHandler.hasFocus(jComponent);
        AquaUIPainter.State state = this.getState(jComponent, this.isGrayed);
        object3 = new AppearanceContext(aquaAppearance, state, bl, false);
        object2 = containerContextualColors.getBackground((AppearanceContext)object3);
        Color color = containerContextualColors.getForeground((AppearanceContext)object3);
        this.setBackground(AquaColors.getOrdinaryColor((Color)object2));
        this.setForeground(AquaColors.getOrdinaryColor(color));
        this.arrowColor = this.getArrowColor(fileInfo, bl2, aquaAppearance);
        this.text = fileInfo.getUserName();
        this.icon = fileInfo.getIcon();
        this.isAlias = false;
        if (fileInfo instanceof FileSystemTreeModel.Node) {
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)fileInfo;
            this.isAlias = node.isAlias();
        }
        this.setOpaque(!bl3);
        this.setEnabled(jComponent.isEnabled());
        this.setFont(jComponent.getFont());
        this.setBorder(bl3 ? null : this.border);
        return this;
    }

    @Nullable
    protected Color getArrowColor(@NotNull FileInfo fileInfo, boolean bl, @NotNull AquaAppearance aquaAppearance) {
        if (this.isListView) {
            return null;
        }
        if (!fileInfo.isTraversable() || OSXFile.isVirtualFile(fileInfo.lazyGetResolvedFile())) {
            return null;
        }
        if (this.isSelected) {
            if (bl) {
                return aquaAppearance.getColor("selectedBrowserExpandArrow_focused");
            }
            return aquaAppearance.getColor("selectedBrowserExpandArrow");
        }
        return aquaAppearance.getColor("browserExpandArrow");
    }

    @Nullable
    protected Color getLabelBorderColor() {
        return this.isSelected && this.isFocused ? LABEL_BORDER_SELECTED : null;
    }

    @NotNull
    protected AquaUIPainter.State getState(@NotNull JComponent jComponent, boolean bl) {
        return jComponent.isEnabled() && !bl ? (AquaFocusHandler.hasFocus(jComponent) ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.DISABLED;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Image image;
        Object object = AquaUtils.beginGraphics((Graphics2D)graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n, n2);
        FileRenderer.viewRect.x += insets.left;
        FileRenderer.viewRect.y += insets.top;
        FileRenderer.viewRect.width -= insets.left + insets.right;
        FileRenderer.viewRect.height -= insets.top + insets.bottom;
        Font font = this.getFont();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, n, n2);
        }
        String string = this.layoutRenderer(fontMetrics, viewRect, iconRect, textRect, arrowIconRect, labelRect, this.text == null ? 0 : this.textIconGap, this.textArrowIconGap);
        if (this.labelColor != null) {
            double d = this.labelRadius;
            Ellipse2D.Double double_ = new Ellipse2D.Double(FileRenderer.labelRect.x, FileRenderer.labelRect.y, d * 2.0, d * 2.0);
            graphics2D.setPaint(this.labelColor);
            graphics2D.fill(double_);
            Color color = this.getLabelBorderColor();
            if (color != null) {
                graphics2D.setPaint(color);
                graphics2D.draw(double_);
            }
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, graphics2D, FileRenderer.iconRect.x, FileRenderer.iconRect.y);
        }
        if (this.isAlias && this.aliasBadgeIcon != null) {
            this.aliasBadgeIcon.paintIcon(this, graphics2D, FileRenderer.iconRect.x, FileRenderer.iconRect.y);
        }
        if (string != null && !string.equals("")) {
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(string, FileRenderer.textRect.x, FileRenderer.textRect.y + fontMetrics.getAscent());
        }
        if (this.arrowColor != null && (image = AquaImageFactory.getProcessedImage(this.arrowIcon, (Object)this.arrowColor)) != null) {
            graphics2D.drawImage(image, FileRenderer.arrowIconRect.x, FileRenderer.arrowIconRect.y, null);
        }
        AquaUtils.endGraphics(graphics2D, object);
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        labelRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets;
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.resetRects();
        this.layoutRenderer(fontMetrics, viewRect, iconRect, textRect, arrowIconRect, labelRect, this.text == null ? 0 : this.textIconGap, this.textArrowIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(FileRenderer.iconRect.x, FileRenderer.iconRect.y, FileRenderer.iconRect.width, FileRenderer.iconRect.height, r);
        if (this.arrowColor != null) {
            FileRenderer.r.width += FileRenderer.arrowIconRect.width + this.textArrowIconGap;
        }
        if (this.labelColor != null) {
            FileRenderer.r.width += FileRenderer.labelRect.width + this.textArrowIconGap;
        }
        if ((insets = this.getInsets()) != null) {
            FileRenderer.r.width += insets.left + insets.right;
            FileRenderer.r.height += insets.top + insets.bottom;
        }
        return r.getSize();
    }

    private String layoutRenderer(@NotNull FontMetrics fontMetrics, @NotNull Rectangle rectangle, @NotNull Rectangle rectangle2, @NotNull Rectangle rectangle3, @NotNull Rectangle rectangle4, @NotNull Rectangle rectangle5, int n, int n2) {
        int n3;
        boolean bl = this.arrowColor != null;
        boolean bl2 = this.labelColor != null;
        int n4 = this.arrowIcon.getIconWidth();
        int n5 = this.arrowIcon.getIconHeight();
        int n6 = n3 = (int)Math.ceil(2.0 * this.labelRadius);
        if (bl) {
            rectangle4.width = n4;
            rectangle4.height = n5;
            rectangle4.x = rectangle.x + rectangle.width - n4;
        }
        rectangle.width -= n4 + n2;
        if (bl2) {
            rectangle5.width = n3;
            rectangle5.height = n6;
            rectangle5.x = rectangle.x + rectangle.width - n3;
        }
        rectangle.width -= n3 + n2;
        Dimension dimension = this.icon != null ? new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()) : null;
        this.text = AquaUtils.layoutCompoundLabel(this, fontMetrics, this.text, dimension, 0, 2, 0, 4, rectangle, rectangle2, rectangle3, n);
        rectangle.width += n3 + n2;
        rectangle.width += n4 + n2;
        Rectangle rectangle6 = rectangle2.union(rectangle3);
        if (bl) {
            rectangle4.y = rectangle.y + rectangle6.height / 2 - n5 / 2;
        }
        if (bl2) {
            rectangle5.y = rectangle.y + rectangle6.height / 2 - n6 / 2;
        }
        if (!AquaUtils.isLeftToRight(this)) {
            int n7 = rectangle.width;
            rectangle2.x = n7 - (rectangle2.x + rectangle2.width);
            rectangle3.x = n7 - (rectangle3.x + rectangle3.width);
            rectangle4.x = n7 - (rectangle4.x + n4);
            rectangle5.x = n7 - (rectangle5.x + n3);
        }
        return this.text;
    }
}

