/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.Colors;
import org.violetlib.aqua.ColorsBuilder;
import org.violetlib.aqua.ColorsInstrumentation;
import org.violetlib.aqua.Logger;
import org.violetlib.aqua.SystemColors;
import org.violetlib.aqua.Utils;
import org.violetlib.jnr.aqua.AquaNativeRendering;
import org.violetlib.vappearances.VAppearance;

public class AppearanceColorsBuilder {
    @Nullable
    private final ColorsInstrumentation instrumentation;
    @NotNull
    private final Colors result;
    private static final Map<Integer, SystemColors> systemColorsMap = new HashMap<Integer, SystemColors>();

    public AppearanceColorsBuilder(@NotNull VAppearance vAppearance, int n, @Nullable Map<String, Color> map, @Nullable ColorsInstrumentation colorsInstrumentation, @Nullable Logger logger) {
        this.instrumentation = colorsInstrumentation;
        if (logger == null) {
            logger = Utils::logDebug;
        }
        if (map == null) {
            map = AquaNativeRendering.createPainter().getColors(vAppearance);
        }
        String string = vAppearance.getName();
        SystemColors systemColors = this.getSystemColors(n, logger);
        ColorsBuilder colorsBuilder = new ColorsBuilder(string, colorsInstrumentation, logger);
        colorsBuilder.add(systemColors.defaultColors, "Default");
        colorsBuilder.addAll(vAppearance.getColors());
        colorsBuilder.addAll(map);
        colorsBuilder.add("controlText_disabled", "disabledControlText");
        if (vAppearance.isDark()) {
            colorsBuilder.add(systemColors.darkColors, "Dark");
            if (vAppearance.isHighContrast()) {
                colorsBuilder.add(systemColors.highContrastDarkColors, "High Contrast Dark");
            }
        } else {
            colorsBuilder.add(systemColors.lightColors, "Light");
            if (vAppearance.isHighContrast()) {
                colorsBuilder.add(systemColors.highContrastLightColors, "High Contrast Light");
            }
        }
        this.installFixups(colorsBuilder, vAppearance, n);
        this.result = colorsBuilder.getColors();
        if (colorsInstrumentation != null) {
            colorsInstrumentation.colorsReady(new MyAccess(this.result));
        }
    }

    @NotNull
    public Colors getResult() {
        return this.result;
    }

    @NotNull
    private SystemColors getSystemColors(int n2, @NotNull Logger logger) {
        return systemColorsMap.computeIfAbsent(n2, n -> new SystemColors((int)n, this.instrumentation, logger));
    }

    private void installFixups(@NotNull ColorsBuilder colorsBuilder, @NotNull VAppearance vAppearance, int n) {
        Color color;
        if (n < 1014) {
            boolean bl;
            color = colorsBuilder.get("controlAccent");
            boolean bl2 = bl = color != null && color.getBlue() - color.getRed() < 30;
            if (bl) {
                colorsBuilder.add("menuSelectedBackground", 162, 162, 168);
            } else {
                colorsBuilder.add("menuSelectedBackground", 54, 148, 253);
            }
            colorsBuilder.add("comboBoxMenuBackground", 255);
            colorsBuilder.add("menuBackground", 0, 0);
            colorsBuilder.add("menuForeground", 61);
        }
        if (vAppearance.isDark() && (color = colorsBuilder.get("alternatingContentBackground_1_disabled")) != null && color.getRed() == 255 && color.getAlpha() == 128) {
            colorsBuilder.add("alternatingContentBackground_1_disabled", 128, 13);
        }
    }

    private static class MyAccess
    implements ColorsInstrumentation.Access {
        @NotNull
        private final Colors colors;

        public MyAccess(@NotNull Colors colors) {
            this.colors = colors;
        }

        @Override
        @NotNull
        public String[] getColorNames() {
            return this.colors.getColorNames().toArray(new String[0]);
        }

        @Override
        @Nullable
        public Color getColor(@NotNull String string) {
            return this.colors.get(string);
        }

        @Override
        @Nullable
        public String getSynonym(@NotNull String string) {
            return null;
        }
    }
}

