/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaBasicPopupMenuWrapper;
import org.violetlib.aqua.AquaExtendedPopup;
import org.violetlib.aqua.AquaPopupMenuUI;
import org.violetlib.aqua.AquaScrollingPopupMenuWrapper;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.MenuVibrantEffects;

public class AquaContextualPopup {
    private JComponent wrapper;
    private Popup p;
    @Nullable
    private MenuVibrantEffects effects;

    public AquaContextualPopup(JComponent jComponent, Component component, boolean bl, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        int n6;
        Border border = AquaContextualPopup.getContextualMenuBorder();
        Insets insets = border.getBorderInsets(null);
        Dimension dimension = jComponent.getPreferredSize();
        if (n3 <= 0) {
            n3 = dimension.width + insets.left + insets.right;
        }
        if (n4 <= 0) {
            n4 = dimension.height + insets.top + insets.bottom;
        }
        Rectangle rectangle2 = AquaUtils.getScreenBounds(new Point(n, n2), component);
        if (n2 < rectangle2.y) {
            n6 = rectangle2.y - n2;
            n2 = rectangle2.y;
            n4 -= n6;
        }
        n6 = rectangle2.width;
        int n7 = rectangle2.height;
        if (n3 > n6) {
            n3 = n6;
        }
        if (n3 > (n5 = rectangle2.x + rectangle2.width - n)) {
            n = rectangle2.x + rectangle2.width - n3;
        }
        if (n4 > n7) {
            n4 = n7;
        }
        if (n4 > (n5 = rectangle2.y + rectangle2.height - n2)) {
            n4 = n5;
        }
        if (n3 < dimension.width + insets.left + insets.right || n4 < dimension.height + insets.top + insets.bottom) {
            if (point != null) {
                point = new Point(point.x - n, point.y - n2);
            }
            this.wrapper = new MyScrollingWrapper(jComponent, rectangle, point, n3, n4, border);
        } else {
            this.wrapper = new AquaBasicPopupMenuWrapper(jComponent, border);
        }
        Border border2 = jComponent.getBorder();
        if (border2 == null || border2 instanceof UIResource) {
            jComponent.setBorder(null);
        }
        this.wrapper.putClientProperty("AquaPopup.backgroundStyle", "vibrantMenu");
        this.wrapper.putClientProperty("AquaPopup.cornerRadius", 6);
        if (bl && jComponent instanceof JPopupMenu) {
            object = (JPopupMenu)jComponent;
            this.effects = new MenuVibrantEffects(this.wrapper, (JPopupMenu)object, 4);
        }
        object = PopupFactory.getSharedInstance();
        this.p = ((PopupFactory)object).getPopup(component, this.wrapper, n, n2);
    }

    public Popup getPopup() {
        return this.p;
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.wrapper.dispatchEvent(aWTEvent);
    }

    public static Border getContextualMenuBorder() {
        return new EmptyBorder(5, 0, 5, 0);
    }

    protected class MyScrollingWrapper
    extends AquaScrollingPopupMenuWrapper {
        public MyScrollingWrapper(JComponent jComponent, Rectangle rectangle, Point point, int n, int n2, Border border) {
            super(jComponent, rectangle, point, n, n2, border);
            if (jComponent instanceof JPopupMenu) {
                Object object = AquaPopupMenuUI.getHidePopupKey();
                this.putClientProperty("doNotCancelPopup", object);
                int n3 = this.getComponentCount();
                for (int i = 0; i < n3; ++i) {
                    JComponent jComponent2 = (JComponent)this.getComponent(i);
                    jComponent2.putClientProperty("doNotCancelPopup", object);
                }
            }
        }

        @Override
        protected void scroll(MouseEvent mouseEvent, int n) {
            Point point = AquaUtils.getScreenLocation(AquaContextualPopup.this.wrapper);
            Rectangle rectangle = AquaUtils.getScreenBounds(point, AquaContextualPopup.this.wrapper);
            Window window = SwingUtilities.getWindowAncestor(AquaContextualPopup.this.wrapper);
            if (window != null) {
                int n2;
                if (n > 0) {
                    n2 = window.getY() - rectangle.y;
                    if (n2 > 0) {
                        int n3 = Math.min(n, n2);
                        window.setBounds(window.getX(), window.getY() - n3, window.getWidth(), window.getHeight() + n3);
                        window.invalidate();
                        window.validate();
                        this.height += n3;
                        n -= n3;
                        this.configure(true);
                    }
                } else {
                    n2 = rectangle.y + rectangle.height - (window.getY() + window.getHeight());
                    if (n2 > 0) {
                        int n4 = Math.min(-n, n2);
                        window.setBounds(window.getX(), window.getY(), window.getWidth(), window.getHeight() + n4);
                        window.invalidate();
                        window.validate();
                        n += n4;
                        this.height += n4;
                        Point point2 = this.viewport.getViewPosition();
                        this.viewport.setViewPosition(new Point(point2.x, point2.y - n4));
                        this.configure(true);
                    }
                }
                if (n != 0) {
                    super.scroll(mouseEvent, n);
                }
                if (mouseEvent != null && this.originalContent instanceof AquaExtendedPopup) {
                    AquaExtendedPopup aquaExtendedPopup = (AquaExtendedPopup)((Object)this.originalContent);
                    aquaExtendedPopup.updateSelection(mouseEvent);
                }
            }
        }
    }
}

