/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.BasicColors;
import org.violetlib.aqua.ColorsInstrumentation;
import org.violetlib.aqua.GradientColor;
import org.violetlib.aqua.Logger;

public class BasicColorsBuilder {
    public static final int NO_INACTIVE = 1;
    private static final List<String> allColorSuffixes = Collections.unmodifiableList(Arrays.asList("_rollover", "_pressed", "_inactive", "_disabled", "_inactive_disabled", "_focused"));
    @NotNull
    public final Map<String, Color> colors = new HashMap<String, Color>();
    @NotNull
    public final Map<String, String> synonyms = new HashMap<String, String>();
    @NotNull
    protected final String context;
    @Nullable
    protected final ColorsInstrumentation instrumentation;
    @Nullable
    protected final ColorsInstrumentation.Access access;
    @NotNull
    protected final Logger log;

    public BasicColorsBuilder(@NotNull String string, @Nullable ColorsInstrumentation colorsInstrumentation, @NotNull Logger logger) {
        this.context = string;
        this.instrumentation = colorsInstrumentation;
        this.access = colorsInstrumentation != null ? new Access() : null;
        this.log = logger;
    }

    @NotNull
    public static List<String> getAllColorSuffixes() {
        return allColorSuffixes;
    }

    @Nullable
    public static String withoutInactive(@NotNull String string) {
        if (string.equals("_inactive")) {
            return "";
        }
        if (string.equals("_inactive_disabled")) {
            return "_disabled";
        }
        return null;
    }

    @NotNull
    public BasicColors get() {
        Map<String, Color> map = Collections.unmodifiableMap(new HashMap<String, Color>(this.colors));
        Map<String, String> map2 = Collections.unmodifiableMap(new HashMap<String, String>(this.synonyms));
        return new BasicColors(map, map2);
    }

    public void add(@NotNull String string, int n) {
        ColorUIResource colorUIResource = new ColorUIResource(n, n, n);
        this.internalAdd(string, colorUIResource);
    }

    public void add(@NotNull String string, int n, int n2, int n3) {
        ColorUIResource colorUIResource = new ColorUIResource(n, n2, n3);
        this.internalAdd(string, colorUIResource);
    }

    public void add(@NotNull String string, int n, int n2, int n3, int n4) {
        ColorUIResource colorUIResource = new ColorUIResource(new Color(n, n2, n3, n4));
        this.internalAdd(string, colorUIResource);
    }

    public void add(@NotNull String string, int n, int n2) {
        ColorUIResource colorUIResource = new ColorUIResource(new Color(n, n, n, n2));
        this.internalAdd(string, colorUIResource);
    }

    public void addColorGradient(@NotNull String string, int n, int n2, int n3) {
        Color color = new Color(n, n, n, n3);
        Color color2 = new Color(n2, n2, n2, n3);
        GradientColor gradientColor = new GradientColor(color, color2, this.log);
        this.internalAdd(string, gradientColor);
    }

    public void addMagicColorGradient(@NotNull String string, int n, int n2, int n3) {
        Color color = new Color(n, n, n, n3);
        Color color2 = new Color(n2, n2, n2, n3);
        GradientColor gradientColor = new GradientColor(color, color2, true, this.log);
        this.internalAdd(string, gradientColor);
    }

    public void addAlphaGradient(@NotNull String string, int n, int n2, int n3) {
        Color color = new Color(n, n, n, n2);
        Color color2 = new Color(n, n, n, n3);
        GradientColor gradientColor = new GradientColor(color, color2, this.log);
        this.internalAdd(string, gradientColor);
    }

    public void addMagicAlphaGradient(@NotNull String string, int n, int n2, int n3) {
        Color color = new Color(n, n, n, n2);
        Color color2 = new Color(n, n, n, n3);
        GradientColor gradientColor = new GradientColor(color, color2, true, this.log);
        this.internalAdd(string, gradientColor);
    }

    public void add(@NotNull String string, @NotNull Color color) {
        this.internalAdd(string, color);
    }

    public void add(@NotNull String string, @NotNull String string2) {
        this.internalAdd(string, string2);
    }

    public void addAll(@NotNull String string, @NotNull String string2) {
        String string32;
        this.add(string, string2);
        for (String string32 : BasicColorsBuilder.getAllColorSuffixes()) {
            this.addDerived(string, string2, string32);
        }
        String string4 = AquaColors.createSelectedColorName(string);
        string32 = AquaColors.createSelectedColorName(string2);
        this.add(string4, string32);
        for (String string5 : BasicColorsBuilder.getAllColorSuffixes()) {
            this.addDerived(string4, string32, string5);
        }
    }

    private void addDerived(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        this.add(string + string3, string2 + string3);
    }

    public void addAll(@NotNull String string, @NotNull String string2, int n) {
        String string32;
        this.add(string, string2);
        for (String string32 : BasicColorsBuilder.getAllColorSuffixes()) {
            this.addDerived(string, string2, string32, n);
        }
        String string4 = AquaColors.createSelectedColorName(string);
        string32 = AquaColors.createSelectedColorName(string2);
        this.add(string4, string32);
        for (String string5 : BasicColorsBuilder.getAllColorSuffixes()) {
            this.addDerived(string4, string32, string5, n);
        }
    }

    private void addDerived(@NotNull String string, @NotNull String string2, @NotNull String string3, int n) {
        String string4;
        if ((n & 1) != 0 && (string4 = BasicColorsBuilder.withoutInactive(string3)) != null) {
            this.add(string + string3, string + string4);
            return;
        }
        this.add(string + string3, string2 + string3);
    }

    public void defineNoInactive(@NotNull String string) {
        for (String object : BasicColorsBuilder.getAllColorSuffixes()) {
            String string2 = BasicColorsBuilder.withoutInactive(object);
            if (string2 == null) continue;
            this.add(string + object, string + string2);
        }
        String string3 = AquaColors.createSelectedColorName(string);
        for (String string2 : BasicColorsBuilder.getAllColorSuffixes()) {
            String string4 = BasicColorsBuilder.withoutInactive(string2);
            if (string4 == null) continue;
            this.add((String)string3 + string2, (String)string3 + string4);
        }
    }

    protected void internalAdd(@NotNull String string, @NotNull Color color) {
        if (this.instrumentation != null) {
            assert (this.access != null);
            this.instrumentation.addingColor(this.context, string, color, this.access);
        }
        this.synonyms.remove(string);
        if (!(color instanceof ColorUIResource)) {
            color = new ColorUIResource(color);
        }
        this.colors.put(string, color);
    }

    protected void internalAdd(@NotNull String string, @NotNull String string2) {
        if (this.instrumentation != null) {
            assert (this.access != null);
            this.instrumentation.addingSynonym(this.context, string, string2, this.access);
        }
        this.colors.remove(string);
        this.synonyms.put(string, string2);
    }

    public void remove(@NotNull String string) {
        if (this.instrumentation != null) {
            assert (this.access != null);
            this.instrumentation.removingColor(this.context, string, this.access);
        }
        this.colors.remove(string);
    }

    private class Access
    implements ColorsInstrumentation.Access {
        private Access() {
        }

        @Override
        @NotNull
        public String[] getColorNames() {
            return BasicColorsBuilder.this.colors.keySet().toArray(new String[0]);
        }

        @Override
        @Nullable
        public Color getColor(@NotNull String string) {
            return BasicColorsBuilder.this.colors.get(string);
        }

        @Override
        @Nullable
        public String getSynonym(@NotNull String string) {
            return BasicColorsBuilder.this.synonyms.get(string);
        }
    }
}

