/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.SelectionBoundsTracker;

public abstract class ListSelectionBoundsTracker
implements SelectionBoundsTracker {
    @Nullable
    protected JList<?> list;
    @Nullable
    protected Consumer<SelectionBoundsDescription> consumer;
    @Nullable
    private SelectionBoundsDescription currentSelectionDescription;

    public ListSelectionBoundsTracker(@NotNull JList<?> jList, @Nullable Consumer<SelectionBoundsDescription> consumer) {
        this.list = jList;
        this.consumer = consumer;
        this.update();
        if (consumer != null && this.currentSelectionDescription == null) {
            consumer.accept(null);
        }
    }

    @Override
    public void dispose() {
        this.list = null;
        this.consumer = null;
    }

    @Override
    public void reset() {
        if (this.currentSelectionDescription != null) {
            this.currentSelectionDescription = null;
            if (this.consumer != null) {
                this.consumer.accept(null);
            }
        }
    }

    @Override
    public void setConsumer(@Nullable Consumer<SelectionBoundsDescription> consumer) {
        if (consumer != this.consumer) {
            this.consumer = consumer;
            if (consumer != null) {
                consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    @Override
    public void update() {
        if (this.list != null) {
            int[] nArray = this.getSelectedIndices(this.list);
            try {
                this.updateFromSelectedRows(nArray);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    private int @NotNull [] getSelectedIndices(@NotNull JList<?> jList) {
        int n = jList.getMinSelectionIndex();
        int n2 = jList.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int[] nArray = new int[n2 - n + 1];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!jList.isSelectedIndex(i)) continue;
            nArray[n3++] = i;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    protected void updateFromSelectedRows(int @NotNull [] nArray) {
        SelectionBoundsDescription selectionBoundsDescription = this.createSelectionDescription(nArray);
        if (!Objects.equals(selectionBoundsDescription, this.currentSelectionDescription)) {
            this.currentSelectionDescription = selectionBoundsDescription;
            if (this.consumer != null) {
                this.consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    @Nullable
    private SelectionBoundsDescription createSelectionDescription(int @Nullable [] nArray) {
        if (this.list == null || nArray == null) {
            return null;
        }
        SelectionBoundsDescription selectionBoundsDescription = new SelectionBoundsDescription(nArray.length);
        for (int n : nArray) {
            Rectangle rectangle = this.list.getCellBounds(n, n);
            int n2 = this.convertRowYCoordinateToSelectionDescription(rectangle.y);
            selectionBoundsDescription.addRegion(n2, rectangle.height);
        }
        return selectionBoundsDescription;
    }

    protected int convertRowYCoordinateToSelectionDescription(int n) {
        return n;
    }
}

