/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaButtonToggleUI;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.VAquaRenderingAccess;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class SegmentedControlModel {
    protected static final Map<Container, SegmentedControlModel> parentCache = new HashMap<Container, SegmentedControlModel>();
    @NotNull
    private final Container parent;
    @NotNull
    private final @NotNull JToggleButton @NotNull [] buttons;
    @Nullable
    private final ButtonGroup group;
    private final boolean isAllIcon;
    private boolean isValid = true;
    private boolean lastRolloverState;
    @NotNull
    private final ContainerListener myContainerListener;
    @NotNull
    private final ComponentListener myComponentListener;
    @NotNull
    private final PropertyChangeListener myPropertyChangeListener;

    private SegmentedControlModel(@NotNull Container container, @NotNull @NotNull JToggleButton @NotNull [] jToggleButtonArray, @Nullable ButtonGroup buttonGroup, boolean bl) {
        this.parent = container;
        this.buttons = jToggleButtonArray;
        this.group = buttonGroup;
        this.isAllIcon = bl;
        parentCache.put(container, this);
        this.myComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                SegmentedControlModel.this.invalidate();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                SegmentedControlModel.this.invalidate();
            }
        };
        this.myContainerListener = new ContainerAdapter(){

            @Override
            public void componentAdded(@NotNull ContainerEvent containerEvent) {
                this.update(containerEvent);
            }

            @Override
            public void componentRemoved(@NotNull ContainerEvent containerEvent) {
                this.update(containerEvent);
            }

            void update(@NotNull ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (SegmentedControlModel.identifySegmentedButton(component) != null) {
                    SegmentedControlModel.this.invalidate();
                }
            }
        };
        this.myPropertyChangeListener = propertyChangeEvent -> {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null) {
                if (string.equals("UI") || string.equals("JButton.buttonType") || string.equals("JButton.segmentPosition")) {
                    this.invalidate();
                } else if (string.equals("text") || string.equals("icon")) {
                    this.validateAllIconStatus();
                }
            }
        };
        container.addContainerListener(this.myContainerListener);
        for (JToggleButton jToggleButton : jToggleButtonArray) {
            jToggleButton.addComponentListener(this.myComponentListener);
            jToggleButton.addPropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    @NotNull
    public Container getParent() {
        return this.parent;
    }

    public int count() {
        return this.buttons.length;
    }

    @NotNull
    public JToggleButton get(int n) {
        return this.buttons[n];
    }

    @Nullable
    public ButtonGroup getGroup() {
        return this.group;
    }

    public boolean isExclusive() {
        return this.group != null;
    }

    public boolean isAllIcon() {
        return this.isAllIcon;
    }

    public boolean isRollover() {
        JToggleButton jToggleButton = this.buttons[0];
        if (!jToggleButton.isRolloverEnabled()) {
            return false;
        }
        boolean bl = this.getRolloverState();
        if (bl != this.lastRolloverState) {
            for (JToggleButton jToggleButton2 : this.buttons) {
                jToggleButton2.repaint();
            }
        }
        this.lastRolloverState = bl;
        return bl;
    }

    private boolean getRolloverState() {
        for (JToggleButton jToggleButton : this.buttons) {
            ButtonModel buttonModel = jToggleButton.getModel();
            if (!buttonModel.isRollover()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JToggleButton getLeftAdjacentButton(@NotNull JToggleButton jToggleButton) {
        int n = this.count();
        for (int i = 0; i < n; ++i) {
            JToggleButton jToggleButton2 = this.get(i);
            if (jToggleButton2 != jToggleButton) continue;
            return i > 0 ? this.get(i - 1) : null;
        }
        return null;
    }

    @Nullable
    public JToggleButton getRightAdjacentButton(@NotNull JToggleButton jToggleButton) {
        int n = this.count();
        for (int i = 0; i < n; ++i) {
            JToggleButton jToggleButton2 = this.get(i);
            if (jToggleButton2 != jToggleButton) continue;
            return i < n - 1 ? this.get(i + 1) : null;
        }
        return null;
    }

    public boolean isValid() {
        if (!this.isValid) {
            return false;
        }
        if (this.buttonGroupsHaveChanged()) {
            this.invalidate();
            return false;
        }
        return true;
    }

    private void invalidate() {
        if (this.isValid) {
            this.isValid = false;
            this.parent.removeContainerListener(this.myContainerListener);
            for (JToggleButton jToggleButton : this.buttons) {
                jToggleButton.removeComponentListener(this.myComponentListener);
                jToggleButton.removePropertyChangeListener(this.myPropertyChangeListener);
            }
            parentCache.remove(this.parent);
        }
    }

    private void validateAllIconStatus() {
        boolean bl = SegmentedControlModel.computeIsAllIcon(this.buttons);
        if (bl != this.isAllIcon) {
            this.invalidate();
        }
    }

    private static boolean computeIsAllIcon(@NotNull @NotNull JToggleButton @NotNull [] jToggleButtonArray) {
        for (JToggleButton jToggleButton : jToggleButtonArray) {
            if (AquaButtonBorder.isIconOnly(jToggleButton)) continue;
            return false;
        }
        return true;
    }

    private boolean buttonGroupsHaveChanged() {
        for (JToggleButton jToggleButton : this.buttons) {
            ButtonGroup buttonGroup = SegmentedControlModel.getButtonGroup(jToggleButton);
            if (buttonGroup == this.group) continue;
            return true;
        }
        return false;
    }

    public void detach() {
        this.invalidate();
    }

    @Nullable
    public static JToggleButton getLeftAdjacentButton(@NotNull AbstractButton abstractButton) {
        SegmentedControlModel segmentedControlModel;
        if (SegmentedControlModel.isPotentialSegmentedControlMember(abstractButton) && (segmentedControlModel = SegmentedControlModel.getSegmentedControlModel(abstractButton)) != null) {
            JToggleButton jToggleButton = (JToggleButton)abstractButton;
            return segmentedControlModel.getLeftAdjacentButton(jToggleButton);
        }
        return null;
    }

    @Nullable
    public static JToggleButton getRightAdjacentButton(@NotNull AbstractButton abstractButton) {
        SegmentedControlModel segmentedControlModel;
        if (SegmentedControlModel.isPotentialSegmentedControlMember(abstractButton) && (segmentedControlModel = SegmentedControlModel.getSegmentedControlModel(abstractButton)) != null) {
            JToggleButton jToggleButton = (JToggleButton)abstractButton;
            return segmentedControlModel.getRightAdjacentButton(jToggleButton);
        }
        return null;
    }

    public static boolean isPotentialSegmentedControlMember(@NotNull AbstractButton abstractButton) {
        if (OSXSystemProperties.OSVersion < 1016) {
            return false;
        }
        return abstractButton instanceof JToggleButton && AquaButtonExtendedTypes.getValidSegmentPosition(abstractButton) != null;
    }

    @NotNull
    public static AquaUIPainter.SegmentedButtonWidget getWidget(@NotNull AbstractButton abstractButton, @NotNull LayoutConfiguration layoutConfiguration) {
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget2 = (AquaUIPainter.SegmentedButtonWidget)layoutConfiguration.getWidget();
        if (OSXSystemProperties.OSVersion >= 1016 && (segmentedButtonWidget = SegmentedControlModel.getSpecialWidget(abstractButton, segmentedButtonWidget2)) != null) {
            return segmentedButtonWidget;
        }
        return segmentedButtonWidget2;
    }

    @Nullable
    public static AquaUIPainter.SegmentedButtonWidget getSpecialWidget(@NotNull AbstractButton abstractButton, @NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget) {
        SegmentedControlModel segmentedControlModel = SegmentedControlModel.getSegmentedControlModel(abstractButton);
        if (segmentedControlModel != null) {
            return SegmentedControlModel.getSpecialWidget(segmentedControlModel, segmentedButtonWidget);
        }
        if ("only".equals(AquaButtonExtendedTypes.getValidSegmentPosition(abstractButton)) && AquaButtonBorder.isIconOnly(abstractButton)) {
            if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR) {
                return VAquaRenderingAccess.SEGMENTED_TEXTURED_TOOLBAR_ICONS_WIDGET;
            }
            if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR) {
                return VAquaRenderingAccess.TEXTURED_SEPARATED_TOOLBAR_ICONS_WIDGET;
            }
        }
        return null;
    }

    @Nullable
    private static AquaUIPainter.SegmentedButtonWidget getSpecialWidget(@NotNull SegmentedControlModel segmentedControlModel, @NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget) {
        if (segmentedControlModel.isExclusive()) {
            if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED) {
                return VAquaRenderingAccess.SLIDER_WIDGET;
            }
            if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR) {
                if (segmentedControlModel.isAllIcon()) {
                    return VAquaRenderingAccess.SLIDER_TOOLBAR_ICONS_WIDGET;
                }
                return VAquaRenderingAccess.SLIDER_TOOLBAR_WIDGET;
            }
            if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR && segmentedControlModel.isAllIcon()) {
                return VAquaRenderingAccess.TEXTURED_SEPARATED_TOOLBAR_ICONS_WIDGET;
            }
        } else if (segmentedControlModel.isAllIcon()) {
            if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR) {
                return VAquaRenderingAccess.SEGMENTED_TEXTURED_TOOLBAR_ICONS_WIDGET;
            }
            if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR) {
                return VAquaRenderingAccess.TEXTURED_SEPARATED_TOOLBAR_ICONS_WIDGET;
            }
        }
        return null;
    }

    public static boolean isRollover(@NotNull AbstractButton abstractButton) {
        Object object;
        if (SegmentedControlModel.isPotentialSegmentedControlMember(abstractButton) && (object = SegmentedControlModel.getSegmentedControlModel(abstractButton)) != null) {
            return ((SegmentedControlModel)object).isRollover();
        }
        object = abstractButton.getModel();
        return object.isRollover();
    }

    @Nullable
    public static SegmentedControlModel getSegmentedControlModel(@NotNull AbstractButton abstractButton) {
        HashSet<JToggleButton> hashSet = new HashSet<JToggleButton>();
        SegmentedControlModel segmentedControlModel = SegmentedControlModel.getCachedSegmentedControlModel(abstractButton);
        if (segmentedControlModel != null) {
            if (segmentedControlModel.isValid()) {
                return segmentedControlModel;
            }
            int n = segmentedControlModel.count();
            for (int i = 0; i < n; ++i) {
                hashSet.add(segmentedControlModel.get(i));
            }
        }
        SegmentedControlModel segmentedControlModel2 = null;
        Container container = abstractButton.getParent();
        if (container != null && (segmentedControlModel2 = SegmentedControlModel.createModel(container)) != null) {
            int n = segmentedControlModel2.count();
            for (int i = 0; i < n; ++i) {
                hashSet.add(segmentedControlModel2.get(i));
            }
        }
        for (JToggleButton jToggleButton : hashSet) {
            AquaButtonUI aquaButtonUI = AquaUtils.getUI(jToggleButton, AquaButtonUI.class);
            if (aquaButtonUI == null) continue;
            aquaButtonUI.configure(jToggleButton);
        }
        return segmentedControlModel2;
    }

    @Nullable
    private static SegmentedControlModel getCachedSegmentedControlModel(@NotNull AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        if (container != null) {
            return parentCache.get(container);
        }
        return null;
    }

    @Nullable
    private static SegmentedControlModel createModel(@NotNull Container container) {
        Serializable serializable;
        ArrayList<JToggleButton> arrayList = new ArrayList<JToggleButton>();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            serializable = container.getComponent(i);
            JToggleButton jToggleButton = SegmentedControlModel.identifySegmentedButton(serializable);
            if (jToggleButton == null) continue;
            arrayList.add(jToggleButton);
        }
        if (arrayList.size() > 1) {
            arrayList.sort(new LocationComparator());
            if (SegmentedControlModel.buttonsAreAdjacent(arrayList) && SegmentedControlModel.hasUniformStyle(arrayList) && SegmentedControlModel.hasValidPositions(arrayList)) {
                JToggleButton[] jToggleButtonArray = arrayList.toArray(new JToggleButton[0]);
                serializable = SegmentedControlModel.identifyButtonGroup(arrayList);
                boolean bl = SegmentedControlModel.computeIsAllIcon(jToggleButtonArray);
                return new SegmentedControlModel(container, jToggleButtonArray, (ButtonGroup)serializable, bl);
            }
        }
        return null;
    }

    @Nullable
    private static JToggleButton identifySegmentedButton(@NotNull Component component) {
        JToggleButton jToggleButton;
        if (component instanceof JToggleButton && (jToggleButton = (JToggleButton)component).getUI().getClass() == AquaButtonToggleUI.class && AquaButtonExtendedTypes.getValidSegmentPosition(jToggleButton) != null) {
            return jToggleButton;
        }
        return null;
    }

    private static boolean buttonsAreAdjacent(@NotNull List<JToggleButton> list) {
        int n = -1000;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            JToggleButton jToggleButton = list.get(i);
            int n3 = jToggleButton.getX();
            if (n != -1000 && n3 != n) {
                return false;
            }
            n = n3 + jToggleButton.getWidth();
        }
        return true;
    }

    private static boolean hasUniformStyle(@NotNull List<JToggleButton> list) {
        String string = null;
        for (JToggleButton jToggleButton : list) {
            String string2 = SegmentedControlModel.getButtonStyle(jToggleButton);
            if (string != null && !string.equals(string2)) {
                return false;
            }
            string = string2;
        }
        return true;
    }

    @NotNull
    private static String getButtonStyle(@NotNull JToggleButton jToggleButton) {
        Object object = jToggleButton.getClientProperty("JButton.buttonType");
        if (object instanceof String) {
            return (String)object;
        }
        return "segmented";
    }

    private static boolean hasValidPositions(@NotNull List<JToggleButton> list) {
        int n = list.size();
        assert (n > 1);
        String string = AquaButtonExtendedTypes.getValidSegmentPosition(list.get(0));
        if (!"first".equals(string)) {
            return false;
        }
        String string2 = AquaButtonExtendedTypes.getValidSegmentPosition(list.get(n - 1));
        if (!"last".equals(string2)) {
            return false;
        }
        for (int i = 1; i < n - 1; ++i) {
            String string3 = AquaButtonExtendedTypes.getValidSegmentPosition(list.get(i));
            if ("middle".equals(string3)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static ButtonGroup identifyButtonGroup(@NotNull List<JToggleButton> list) {
        ButtonGroup buttonGroup = null;
        for (JToggleButton jToggleButton : list) {
            ButtonGroup buttonGroup2 = SegmentedControlModel.getButtonGroup(jToggleButton);
            if (buttonGroup2 == null || buttonGroup != null && buttonGroup != buttonGroup2) {
                return null;
            }
            buttonGroup = buttonGroup2;
        }
        return buttonGroup;
    }

    @Nullable
    private static ButtonGroup getButtonGroup(@NotNull JToggleButton jToggleButton) {
        ButtonModel buttonModel = jToggleButton.getModel();
        if (buttonModel instanceof DefaultButtonModel) {
            DefaultButtonModel defaultButtonModel = (DefaultButtonModel)buttonModel;
            return defaultButtonModel.getGroup();
        }
        return null;
    }

    private static class LocationComparator
    implements Comparator<JToggleButton> {
        private LocationComparator() {
        }

        @Override
        public int compare(JToggleButton jToggleButton, JToggleButton jToggleButton2) {
            int n = jToggleButton.getX();
            int n2 = jToggleButton2.getX();
            return n - n2;
        }
    }
}

