/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.aqua.Utils;
import org.violetlib.aqua.fc.AquaFileIcons;
import org.violetlib.aqua.fc.ConcurrentDispatcher;
import org.violetlib.aqua.fc.FileIconService;
import org.violetlib.aqua.fc.FileIconServiceImplBase;
import org.violetlib.aqua.fc.OSXFile;

public class CatalinaFileIconServiceImpl
extends FileIconServiceImplBase
implements FileIconService {
    @NotNull
    private static final ConcurrentDispatcher dispatcher = new ConcurrentDispatcher();
    @NotNull
    private static final MyHandler myHandlerInstance = new MyHandler();
    @NotNull
    private static final ScheduledExecutorService scheduler;
    @NotNull
    private static UpcallRegistry upcallRegistry;

    @Override
    @NotNull
    public FileIconService.Request requestIcon(@NotNull File file, int n, float f, @NotNull FileIconService.Handler handler) {
        FileIconServiceImplBase.RequestImpl requestImpl = new FileIconServiceImplBase.RequestImpl(this, file, handler, 20);
        this.installGenericFileIcon(file, requestImpl);
        if (OSXFile.isImageFile(file)) {
            long l = upcallRegistry.registerRequest(requestImpl);
            this.installQuickLookFileIcon(file, n, f, l);
        } else {
            dispatcher.dispatch(() -> this.installLaunchServicesFileIcon(file, n, f, requestImpl, 10));
        }
        return requestImpl;
    }

    private void installLaunchServicesFileIcon(@NotNull File file, int n, float f, @NotNull FileIconServiceImplBase.RequestImpl requestImpl, int n2) {
        int[][] nArrayArray;
        String string = file.getAbsolutePath();
        if (!AquaFileIcons.nativeRenderFileImage(string, false, true, nArrayArray = new int[2][], n, n)) {
            if (AquaImageFactory.debugNativeRendering) {
                String string2 = "Launch Services";
                Utils.logDebug("Failed to render " + string2 + " image for " + string);
            }
        } else {
            Object object;
            if (AquaImageFactory.debugNativeRendering) {
                object = "Launch Services";
                Utils.logDebug("Rendered " + (String)object + " image for " + string);
            }
            object = AquaMultiResolutionImage.createImage(n, n, nArrayArray[0], nArrayArray[1]);
            requestImpl.installImage((Image)object, n2);
        }
    }

    private void installQuickLookFileIcon(@NotNull File file, int n, float f, long l) {
        File file2;
        if (OSXFile.getFileType(file) == 2 && (file2 = OSXFile.resolve(file)) != null) {
            file = file2;
        }
        CatalinaFileIconServiceImpl.nativeInstallThumbnails(file.getAbsolutePath(), n, f, l);
    }

    public static native boolean isAvailable();

    private static native void nativeInstallThumbnailHandler(@NotNull MyHandler var0);

    private static native void nativeInstallThumbnails(@NotNull String var0, int var1, float var2, long var3);

    static {
        CatalinaFileIconServiceImpl.nativeInstallThumbnailHandler(myHandlerInstance);
        scheduler = new ScheduledThreadPoolExecutor(0);
        upcallRegistry = new UpcallRegistry();
    }

    private static class UpcallRegistry {
        private final int delayMinutes = 5;
        @NotNull
        private final Map<Long, FileIconServiceImplBase.RequestImpl> map = new HashMap<Long, FileIconServiceImplBase.RequestImpl>();
        private long nextID = 0L;
        @Nullable
        private List<Long> requestsToRemove;

        private UpcallRegistry() {
        }

        public synchronized long registerRequest(@NotNull FileIconServiceImplBase.RequestImpl requestImpl) {
            long l = this.nextID++;
            this.map.put(l, requestImpl);
            if (this.requestsToRemove == null) {
                this.requestsToRemove = new ArrayList<Long>(this.map.keySet());
                scheduler.schedule(this::cleanup, 5L, TimeUnit.MINUTES);
            }
            return l;
        }

        @Nullable
        public synchronized FileIconServiceImplBase.RequestImpl getRequest(long l) {
            return this.map.get(l);
        }

        private synchronized void cleanup() {
            assert (this.requestsToRemove != null);
            for (Long l : this.requestsToRemove) {
                this.map.remove(l);
            }
            if (!this.map.isEmpty()) {
                this.requestsToRemove = new ArrayList<Long>(this.map.keySet());
                scheduler.schedule(this::cleanup, 5L, TimeUnit.MINUTES);
            } else {
                this.requestsToRemove = null;
            }
        }
    }

    public static class MyHandler {
        public void installImage(long l, int n, int n2, @NotNull int[] nArray, float f, int n3) {
            FileIconServiceImplBase.RequestImpl requestImpl = upcallRegistry.getRequest(l);
            if (requestImpl != null) {
                AquaMultiResolutionImage aquaMultiResolutionImage = JavaSupport.createImage(n, n2, nArray, f);
                requestImpl.installImage(aquaMultiResolutionImage, n3);
            } else {
                Utils.logDebug("Image delivered to obsolete request #" + l);
            }
        }
    }
}

