/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Image;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public final class ImageCache {
    protected static boolean debugFlag = false;
    private static int hitCount;
    private static int missCount;
    private final LinkedHashMap<PixelsKey, ImageSoftReference> map = new LinkedHashMap(16, 0.75f, true);
    private final int maxPixelCount;
    private int currentPixelCount = 0;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReferenceQueue<Image> referenceQueue = new ReferenceQueue();
    private static final ImageCache INSTANCE;

    public static ImageCache getInstance() {
        return INSTANCE;
    }

    ImageCache(int n) {
        this.maxPixelCount = n;
    }

    ImageCache() {
        this(0x200000);
    }

    public void flush() {
        this.lock.writeLock().lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Image getImage(@NotNull PixelsKey pixelsKey) {
        Image image;
        ImageSoftReference imageSoftReference;
        this.lock.readLock().lock();
        try {
            imageSoftReference = this.map.get(pixelsKey);
        }
        finally {
            this.lock.readLock().unlock();
        }
        Image image2 = image = imageSoftReference == null ? null : (Image)imageSoftReference.get();
        if (image != null) {
            ++hitCount;
        } else {
            ++missCount;
        }
        if (debugFlag && (hitCount + missCount) % 1000 == 0) {
            System.err.println("Image cache hit rate: " + (float)hitCount / (float)(hitCount + missCount));
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(@NotNull PixelsKey pixelsKey, @NotNull Image image) {
        this.lock.writeLock().lock();
        try {
            ImageSoftReference imageSoftReference = this.map.get(pixelsKey);
            if (imageSoftReference != null) {
                if (imageSoftReference.get() != null) {
                    return;
                }
                this.currentPixelCount -= pixelsKey.getPixelCount();
                this.map.remove(pixelsKey);
            }
            int n = pixelsKey.getPixelCount();
            this.currentPixelCount += n;
            if (this.currentPixelCount > this.maxPixelCount) {
                while ((imageSoftReference = (ImageSoftReference)this.referenceQueue.poll()) != null) {
                    this.map.remove(imageSoftReference.key);
                    this.currentPixelCount -= imageSoftReference.key.getPixelCount();
                }
            }
            if (this.currentPixelCount > this.maxPixelCount) {
                Iterator<Map.Entry<PixelsKey, ImageSoftReference>> iterator = this.map.entrySet().iterator();
                while (this.currentPixelCount > this.maxPixelCount && iterator.hasNext()) {
                    Map.Entry<PixelsKey, ImageSoftReference> entry = iterator.next();
                    iterator.remove();
                    Image image2 = (Image)entry.getValue().get();
                    if (image2 != null) {
                        image2.flush();
                    }
                    this.currentPixelCount -= entry.getValue().key.getPixelCount();
                }
            }
            this.map.put(pixelsKey, new ImageSoftReference(pixelsKey, image, this.referenceQueue));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static {
        INSTANCE = new ImageCache();
    }

    private static class ImageSoftReference
    extends SoftReference<Image> {
        final PixelsKey key;

        ImageSoftReference(PixelsKey pixelsKey, Image image, ReferenceQueue<? super Image> referenceQueue) {
            super(image, referenceQueue);
            this.key = pixelsKey;
        }
    }

    public static interface PixelsKey {
        public int getPixelCount();
    }
}

