/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.ImageUtils;

public abstract class PostProcessedRenderer
implements BasicRenderer {
    @NotNull
    private final BasicRenderer r;
    private static int[] temp;

    public PostProcessedRenderer(@NotNull BasicRenderer basicRenderer) {
        this.r = basicRenderer;
    }

    @Override
    public void render(@NotNull int[] nArray, int n, int n2, float f, float f2) {
        int n3 = n * n2;
        if (n3 > 0) {
            if (temp == null || temp.length < n3) {
                temp = new int[n3];
            } else {
                Arrays.fill(temp, 0);
            }
            this.r.render(temp, n, n2, f, f2);
            this.process(temp, n, n2);
            this.install(temp, nArray, n, n2);
        }
    }

    protected void process(@NotNull int[] nArray, int n, int n2) {
        this.processPixels(nArray, n, n2);
    }

    protected void processPixels(@NotNull int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = i * n + j;
                int n4 = nArray[n3];
                int n5 = this.processRawPixel(i, j, n4);
                if (n5 == n4) continue;
                nArray[n3] = n5;
            }
        }
    }

    protected int processRawPixel(int n, int n2, int n3) {
        int n4 = ImageUtils.alpha(n3);
        if (n4 == 0) {
            return n3;
        }
        int n5 = ImageUtils.red(n3);
        int n6 = ImageUtils.green(n3);
        int n7 = ImageUtils.blue(n3);
        if (n4 > 0) {
            if (n5 > 0) {
                n5 = n5 * 255 / n4;
            }
            if (n6 > 0) {
                n6 = n6 * 255 / n4;
            }
            if (n7 > 0) {
                n7 = n7 * 255 / n4;
            }
        }
        return this.processPixel(n, n2, n5, n6, n7, n4);
    }

    protected abstract int processPixel(int var1, int var2, int var3, int var4, int var5, int var6);

    protected int createPixel(int n, int n2, int n3, int n4) {
        n = this.fix(n);
        n2 = this.fix(n2);
        n3 = this.fix(n3);
        if ((n4 = this.fix(n4)) > 0) {
            if (n > 0) {
                n = n * n4 / 255;
            }
            if (n2 > 0) {
                n2 = n2 * n4 / 255;
            }
            if (n3 > 0) {
                n3 = n3 * n4 / 255;
            }
        }
        int n5 = (n4 << 24) + (n << 16) + (n2 << 8) + n3;
        return n5;
    }

    protected int createPixel(int n, int n2) {
        return this.createPixel(n, n, n, n2);
    }

    protected void install(@NotNull int[] nArray, @NotNull int[] nArray2, int n, int n2) {
        int n3 = n * n2;
        System.arraycopy(nArray, 0, nArray2, 0, n3);
    }

    protected int fix(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }
}

